/*
 * Decompiled with CFR 0.152.
 */
package prospector.traverse.world.features;

import java.util.Random;
import net.minecraft.block.BlockLog;
import net.minecraft.block.BlockSapling;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenAbstractTree;
import net.minecraftforge.common.IPlantable;
import prospector.traverse.world.WorldGenConstants;

public class WorldGenFallenTree
extends WorldGenAbstractTree
implements WorldGenConstants {
    private final int minTreeLength;
    private IBlockState stateWood;

    public WorldGenFallenTree(boolean isWorldGen) {
        this(isWorldGen, 3, OAK_LOG);
    }

    public WorldGenFallenTree(boolean isWorldGen, int minTreeLength, IBlockState stateWood) {
        super(!isWorldGen);
        this.minTreeLength = minTreeLength;
        this.stateWood = stateWood;
    }

    public boolean func_180709_b(World worldIn, Random rand, BlockPos position) {
        EnumFacing orientation;
        int num = rand.nextInt(5);
        if (num == 0) {
            orientation = EnumFacing.EAST;
            this.stateWood = this.stateWood.func_177226_a((IProperty)BlockLog.field_176299_a, (Comparable)BlockLog.EnumAxis.X);
        } else if (num == 1) {
            orientation = EnumFacing.WEST;
            this.stateWood = this.stateWood.func_177226_a((IProperty)BlockLog.field_176299_a, (Comparable)BlockLog.EnumAxis.X);
        } else if (num == 1) {
            orientation = EnumFacing.SOUTH;
            this.stateWood = this.stateWood.func_177226_a((IProperty)BlockLog.field_176299_a, (Comparable)BlockLog.EnumAxis.Z);
        } else {
            orientation = EnumFacing.NORTH;
            this.stateWood = this.stateWood.func_177226_a((IProperty)BlockLog.field_176299_a, (Comparable)BlockLog.EnumAxis.Z);
        }
        int i = rand.nextInt(2) + this.minTreeLength;
        boolean flag = true;
        if (position.func_177956_o() >= 1 && position.func_177956_o() + i + 1 <= worldIn.func_72800_K()) {
            for (int j = position.func_177956_o(); j <= position.func_177956_o() + 1 + i; ++j) {
                int k = 1;
                if (j == position.func_177956_o()) {
                    k = 0;
                }
                if (j >= position.func_177956_o() + 1 + i - 2) {
                    k = 2;
                }
                BlockPos.MutableBlockPos mutablePos = new BlockPos.MutableBlockPos();
                for (int l = position.func_177958_n() - k; l <= position.func_177958_n() + k && flag; ++l) {
                    for (int i1 = position.func_177952_p() - k; i1 <= position.func_177952_p() + k && flag; ++i1) {
                        if (j >= 0 && j < worldIn.func_72800_K()) {
                            if (this.isReplaceable(worldIn, (BlockPos)mutablePos.func_181079_c(l, j, i1))) continue;
                            flag = false;
                            continue;
                        }
                        flag = false;
                    }
                }
            }
            if (!flag) {
                return false;
            }
            IBlockState state = worldIn.func_180495_p(position.func_177977_b());
            if (state.func_177230_c().canSustainPlant(state, (IBlockAccess)worldIn, position.func_177977_b(), EnumFacing.UP, (IPlantable)((BlockSapling)Blocks.field_150345_g)) && position.func_177956_o() < worldIn.func_72800_K() - i - 1) {
                state.func_177230_c().onPlantGrow(state, worldIn, position.func_177977_b(), position);
                for (int j3 = 0; j3 < i; ++j3) {
                    BlockPos offsetPos = position.func_177967_a(orientation, j3);
                    state = worldIn.func_180495_p(offsetPos);
                    if (!state.func_177230_c().isAir(state, (IBlockAccess)worldIn, offsetPos) && !state.func_177230_c().isLeaves(state, (IBlockAccess)worldIn, offsetPos) && state.func_185904_a() != Material.field_151582_l) continue;
                    this.func_175903_a(worldIn, position.func_177967_a(orientation, j3), this.stateWood);
                }
                return true;
            }
            return false;
        }
        return false;
    }
}

